import { db } from '@/editor/indexeddb/db'
import type { ToolInfo } from '@/editor/indexeddb/types'
import { CardList } from '@blueprintjs/core'
import { useLiveQuery } from 'dexie-react-hooks'
import { memo } from 'react'
import Tool from './Tool'

const Tools = () => {
  const tools = useLiveQuery(() => db.tools.toArray(), [], [])

  return (
    <CardList>
      {tools?.map((tool: ToolInfo) => <Tool key={tool.id} tool={tool} />)}
    </CardList>
  )
}

export default memo(Tools)
