import type { Path } from '@/router'
import { useNavigate } from '@/router'
import { Button, Icon, Intent } from '@blueprintjs/core'
import { css } from '@emotion/css'
import { useMemo, type FC } from 'react'
import { useLocation } from 'react-router-dom'
import { NAVIGATION_CONTENT } from '../assets/navigationContent'
import type { NavigationLinkNames } from '../types'

const buttonContent = css`
  display: flex;
  justify-content: space-between;
  align-items: center;
`

interface NavbarButtonProps {
  path: Path
  linkKey: NavigationLinkNames
  visible?: boolean
  filled?: boolean
}

const NavbarButton: FC<NavbarButtonProps> = ({
  path,
  linkKey,
  visible,
  filled,
}) => {
  const nav = useNavigate()
  const { pathname } = useLocation()
  const name = NAVIGATION_CONTENT.links[linkKey]

  const active = useMemo(
    () =>
      path === pathname ||
      (path === '/editor/create/other' &&
        (pathname === '/editor/create/tools' ||
          pathname === '/editor/create/emails')) ||
      ((path === '/editor/create/activity-specification' ||
        path === '/editor/create/inject-specification') &&
        pathname.startsWith(path)),
    [path, pathname]
  )

  const highlighted = useMemo(() => !filled && !active, [filled, active])

  if (!visible) return

  return (
    <Button
      type='button'
      onClick={() => nav(path)}
      alignText='left'
      minimal
      active={active}
      intent={highlighted ? Intent.WARNING : Intent.NONE}
    >
      <div className={buttonContent}>
        <span>{name}</span>
        {highlighted && <Icon icon='high-priority' />}
      </div>
    </Button>
  )
}

export default NavbarButton
