import LearningObjectiveItem from '@/editor/LearningObjectives/LearningObjective'
import { db } from '@/editor/indexeddb/db'
import type { LearningObjectiveInfo } from '@/editor/indexeddb/types'
import { CardList } from '@blueprintjs/core'
import { useLiveQuery } from 'dexie-react-hooks'
import { memo } from 'react'

const LearningObjectives = () => {
  const learningObjectives = useLiveQuery(
    () => db.learningObjectives.toArray(),
    [],
    []
  )

  return (
    <CardList>
      {learningObjectives?.map((objective: LearningObjectiveInfo) => (
        <LearningObjectiveItem
          key={objective.id}
          learningObjective={objective}
        />
      ))}
    </CardList>
  )
}

export default memo(LearningObjectives)
