import { db } from '@/editor/indexeddb/db'
import type { LearningActivityInfo } from '@/editor/indexeddb/types'
import { CardList } from '@blueprintjs/core'
import { useLiveQuery } from 'dexie-react-hooks'
import { memo } from 'react'
import LearningActivity from './LearningActivity'

const LearningActivitiesOverview = () => {
  const learningActivities = useLiveQuery(
    () => db.learningActivities.toArray(),
    [],
    []
  )
  const milestones = useLiveQuery(() => db.milestones.toArray(), [], [])

  return (
    <CardList>
      {learningActivities?.map((activity: LearningActivityInfo) => (
        <LearningActivity
          key={activity.id}
          activity={activity}
          milestones={milestones}
        />
      ))}
    </CardList>
  )
}

export default memo(LearningActivitiesOverview)
