import { useNavigate } from '@/router'
import { Button } from '@blueprintjs/core'
import { css } from '@emotion/css'
import Container from '@inject/shared/components/Container'
import InjectLogo from '@inject/shared/svg/inject-logo--vertical-black.svg?react'
import { isEmpty } from 'lodash'
import { useEffect, useState } from 'react'
import DataRemovalDialog from '../DataRemovalDialog'
import DefinitionUploader from '../DefinitionUploader'
import { GENERIC_CONTENT } from '../assets/generalContent'
import { LANDING_PAGE_ACTIONS } from '../assets/pageContent/landingPage'
import { PAGE_INFORMATION } from '../assets/pageInformation'
import { isDbEmpty } from '../indexeddb/operations'
import { PageNames } from '../types'
import useEditorStorage from '../useEditorStorage'

const logo = css`
  width: 100%;
  height: 200px;
  margin: auto;
`

const container = css`
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: space-around;
`

const introduction = css`
  display: flex;
  flex-direction: column;
  align-items: center;
  text-align: center;
  gap: 0.5rem;
  max-width: 400px;
  width: 100%;
`

const buttonGroup = css`
  display: flex;
  flex-direction: column;
  gap: 0.5rem;
  width: 200px;
`

const LandingPage = () => {
  const nav = useNavigate()
  const [config] = useEditorStorage()
  const [isDataEmpty, setIsDataEmpty] = useState(true)

  useEffect(() => {
    const checkData = async () => {
      const isDbDataEmpty = await isDbEmpty()
      const isConfigDataEmpty = isEmpty(config)
      setIsDataEmpty(isDbDataEmpty && isConfigDataEmpty)
    }
    checkData()
  }, [config])

  return (
    <Container makeFullHeight className={container}>
      <div className={container}>
        <InjectLogo className={logo} />
        <div className={introduction}>
          <h1 style={{ margin: '0' }}>
            {PAGE_INFORMATION[PageNames.LANDING_PAGE].title}
          </h1>
          <p
            dangerouslySetInnerHTML={{
              __html: PAGE_INFORMATION[PageNames.LANDING_PAGE].description,
            }}
            style={{ marginBottom: '1.5rem' }}
          />
          <div className={buttonGroup}>
            <Button
              type='button'
              intent='primary'
              icon={isDataEmpty ? 'plus' : 'arrow-right'}
              onClick={() => nav('/editor/create/introduction')}
            >
              {isDataEmpty
                ? LANDING_PAGE_ACTIONS.create
                : LANDING_PAGE_ACTIONS.edit}
            </Button>
            {!isDataEmpty && (
              <DataRemovalDialog
                openButtonProps={{
                  icon: 'plus',
                  text: LANDING_PAGE_ACTIONS.create,
                }}
                confirmButtonProps={{
                  intent: 'primary',
                  icon: 'tick',
                  text: GENERIC_CONTENT.buttons.confirm,
                }}
                redirectTo='/editor/create/introduction'
              />
            )}
            <DefinitionUploader />
            <Button
              text={LANDING_PAGE_ACTIONS.select}
              icon='list-detail-view'
              onClick={() => nav('/editor/definitions', { state: false })}
            />
          </div>
        </div>
      </div>
    </Container>
  )
}

export default LandingPage
