import Checklist from '@/editor/Checklist'
import useEditorStorage from '@/editor/useEditorStorage'
import { memo, useEffect, useState } from 'react'
import { INTRODUCTION_CONDITIONS } from '../assets/pageContent/introduction'

const IntroductionForm = () => {
  const [config, setConfig] = useEditorStorage()
  const [conditionChecked, setConditionChecked] = useState(
    config?.introChecked || INTRODUCTION_CONDITIONS.map(() => false)
  )

  useEffect(() => {
    setConfig(prev => ({
      ...prev,
      introChecked: conditionChecked,
    }))
  }, [conditionChecked])

  return (
    <Checklist
      conditions={INTRODUCTION_CONDITIONS}
      initChecked={conditionChecked}
      onInputChange={(conditionChecked: boolean[]) =>
        setConditionChecked(conditionChecked)
      }
    />
  )
}

export default memo(IntroductionForm)
