import { db } from '@/editor/indexeddb/db'
import type { InjectInfo } from '@/editor/indexeddb/types'
import { CardList } from '@blueprintjs/core'
import { useLiveQuery } from 'dexie-react-hooks'
import { memo } from 'react'
import Inject from './Inject'

const InjectsOverview = () => {
  const injectInfos = useLiveQuery(() => db.injectInfos.toArray(), [], [])
  const milestones = useLiveQuery(() => db.milestones.toArray(), [], [])

  return (
    <CardList>
      {injectInfos?.map((injectInfo: InjectInfo) => (
        <Inject
          key={injectInfo.id}
          injectInfo={injectInfo}
          milestones={milestones}
        />
      ))}
    </CardList>
  )
}

export default memo(InjectsOverview)
