import Inject from '@/editor/Injects/Inject'
import { CardList } from '@blueprintjs/core'
import { useLiveQuery } from 'dexie-react-hooks'
import { memo } from 'react'
import { db } from '../indexeddb/db'
import type { InjectInfo } from '../indexeddb/types'

const Injects = () => {
  const injects = useLiveQuery(() => db.injectInfos.toArray(), [], [])

  return (
    <CardList>
      {injects?.map((inject: InjectInfo) => (
        <Inject key={inject.id} inject={inject} />
      ))}
    </CardList>
  )
}

export default memo(Injects)
