import TooltipLabel from '@/editor/Tooltips/TooltipLabel'
import { QUESTIONNAIRE_QUESTION_FORM } from '@/editor/assets/pageContent/injectSpecification'
import type { OptionProps } from '@blueprintjs/core'
import {
  ControlGroup,
  NumericInput,
  Radio,
  RadioGroup,
} from '@blueprintjs/core'
import { range } from 'lodash'
import type { FC } from 'react'
import { memo, useEffect, useState } from 'react'

interface QuestionRangeLabelsProps {
  max: number
  correct: number
  onMaxChange: (value: number) => void
  onCorrectChange: (value: number) => void
}

const QuestionRangeLabels: FC<QuestionRangeLabelsProps> = ({
  max,
  correct,
  onMaxChange,
  onCorrectChange,
}) => {
  const [options, setOptions] = useState<OptionProps[]>([])

  useEffect(() => {
    setOptions(
      range(1, max + 1).map(value => ({
        label: value.toString(),
        value: value,
      }))
    )
    if (max < correct) {
      onCorrectChange(1)
    }
  }, [max, correct])

  return (
    <div>
      <TooltipLabel label={QUESTIONNAIRE_QUESTION_FORM.max}>
        <NumericInput
          placeholder='Input number'
          min={1}
          value={max}
          onValueChange={(value: number) => onMaxChange(value)}
        />
      </TooltipLabel>
      <TooltipLabel label={QUESTIONNAIRE_QUESTION_FORM.answers}>
        <RadioGroup onChange={() => {}}>
          {options.map(option => (
            <ControlGroup key={option.value}>
              <Radio
                label={option.label}
                value={option.value}
                checked={correct === option.value}
                onClick={e => onCorrectChange(Number(e.currentTarget.value))}
                onChange={() => {}}
              />
            </ControlGroup>
          ))}
        </RadioGroup>
      </TooltipLabel>
    </div>
  )
}

export default memo(QuestionRangeLabels)
