import { InputGroup, Section, SectionCard } from '@blueprintjs/core'
import { memo, type FC } from 'react'
import TooltipLabel from '../Tooltips/TooltipLabel'
import { TOOL_CHANNEL_FORM } from '../assets/pageContent/finalInformation'

interface ToolChannelFormProps {
  toolChannelName: string
  onToolChannelNameChange: (toolChannelName: string) => void
}

const ToolChannelForm: FC<ToolChannelFormProps> = ({
  toolChannelName,
  onToolChannelNameChange,
}) => (
  <Section title='Tools' style={{ marginBottom: '1rem' }}>
    <SectionCard>
      <TooltipLabel label={TOOL_CHANNEL_FORM.name}>
        <InputGroup
          placeholder='Input text'
          value={toolChannelName}
          onChange={e => onToolChannelNameChange(e.target.value)}
        />
      </TooltipLabel>
    </SectionCard>
  </Section>
)

export default memo(ToolChannelForm)
