import { InputGroup, Section, SectionCard } from '@blueprintjs/core'
import { memo, type FC } from 'react'
import TooltipLabel from '../Tooltips/TooltipLabel'
import { QUESTIONNAIRE_CHANNEL_FORM } from '../assets/pageContent/finalInformation'

interface FormChannelFormProps {
  formChannelName: string
  onFormChannelNameChange: (formChannelName: string) => void
}

const FormChannelForm: FC<FormChannelFormProps> = ({
  formChannelName,
  onFormChannelNameChange,
}) => (
  <Section title='Form'>
    <SectionCard>
      <TooltipLabel label={QUESTIONNAIRE_CHANNEL_FORM.name}>
        <InputGroup
          placeholder='Input text'
          value={formChannelName}
          onChange={e => onFormChannelNameChange(e.target.value)}
        />
      </TooltipLabel>
    </SectionCard>
  </Section>
)

export default memo(FormChannelForm)
