import { Section, SectionCard } from '@blueprintjs/core'
import type { FC } from 'react'
import { memo } from 'react'
import type { FAQQuestion } from '../types'

interface FaqSectionProps {
  questions: FAQQuestion[]
}

const FaqSection: FC<FaqSectionProps> = ({ questions }) => (
  <div style={{ marginTop: '3rem' }}>
    <h2>FAQ</h2>
    {questions.map((question, i) => (
      <Section
        key={i}
        collapsible
        collapseProps={{ defaultIsOpen: false }}
        title={question.question}
      >
        <SectionCard>
          <div
            dangerouslySetInnerHTML={{
              __html: question.answer,
            }}
          />
        </SectionCard>
      </Section>
    ))}
  </div>
)

export default memo(FaqSection)
