import useEditorStorage from '@/editor/useEditorStorage'
import { InputGroup, TextArea } from '@blueprintjs/core'
import { memo, useEffect, useState } from 'react'
import TooltipLabel from '../Tooltips/TooltipLabel'
import { EXERCISE_INFORMATION_FORM } from '../assets/pageContent/exerciseInformation'

const ExerciseInformationForm = () => {
  const [config, setConfig] = useEditorStorage()
  const [name, setName] = useState(config?.name || '')
  const [description, setDescription] = useState(config?.description || '')
  const [trainee, setTrainee] = useState(config?.trainee || '')

  useEffect(() => {
    setConfig(prev => ({
      ...prev,
      name,
      description,
      trainee,
    }))
  }, [name, description, trainee])

  return (
    <div>
      <TooltipLabel label={EXERCISE_INFORMATION_FORM.name}>
        <InputGroup
          placeholder='Input text'
          value={name}
          onChange={e => setName(e.target.value)}
        />
      </TooltipLabel>
      <TooltipLabel label={EXERCISE_INFORMATION_FORM.description}>
        <TextArea
          value={description}
          style={{
            width: '100%',
            height: '5rem',
            resize: 'none',
            overflowY: 'auto',
          }}
          placeholder='Input text'
          onChange={e => setDescription(e.target.value)}
        />
      </TooltipLabel>
      <TooltipLabel label={EXERCISE_INFORMATION_FORM.trainee}>
        <InputGroup
          placeholder='Input text'
          value={trainee}
          onChange={e => setTrainee(e.target.value)}
        />
      </TooltipLabel>
    </div>
  )
}

export default memo(ExerciseInformationForm)
