import { db } from '@/editor/indexeddb/db'
import type { EmailAddressInfo } from '@/editor/indexeddb/types'
import { CardList } from '@blueprintjs/core'
import { useLiveQuery } from 'dexie-react-hooks'
import { memo } from 'react'
import EmailAddress from './EmailAddress'

const EmailAddresses = () => {
  const emailAddresses = useLiveQuery(() => db.emailAddresses.toArray(), [], [])

  return (
    <CardList>
      {emailAddresses?.map((emailAddress: EmailAddressInfo) => (
        <EmailAddress key={emailAddress.id} emailAddress={emailAddress} />
      ))}
    </CardList>
  )
}

export default memo(EmailAddresses)
