import useEditorStorage from '@/editor/useEditorStorage'
import { downloadDefinitionZip } from '@/editor/zip/createDefinitionZip'
import { Button, ButtonGroup } from '@blueprintjs/core'
import { memo } from 'react'
import CommitDefinition from '../CommitDefinition'
import DataRemovalDialog from '../DataRemovalDialog'
import { GENERIC_CONTENT } from '../assets/generalContent'

const DownloadDefinition = () => {
  const [config] = useEditorStorage()

  const handleDownloadYaml = async () => {
    downloadDefinitionZip(config || {})
  }

  return (
    <ButtonGroup style={{ gap: '0.5rem' }}>
      <Button icon='download' intent='primary' onClick={handleDownloadYaml}>
        Download YAML
      </Button>
      <CommitDefinition />
      <DataRemovalDialog
        openButtonProps={{
          icon: 'trash',
          text: 'Clear definition',
        }}
        confirmButtonProps={{
          intent: 'primary',
          icon: 'tick',
          text: GENERIC_CONTENT.buttons.confirm,
        }}
        redirectTo='/editor'
      />
    </ButtonGroup>
  )
}
export default memo(DownloadDefinition)
