import type { Project } from '@/editor/gitlabAccess'
import { Card } from '@blueprintjs/core'
import { css } from '@emotion/css'
import { memo, type FC } from 'react'
import BranchSelectorDialog from './BranchSelectorDialog'

const definition = css`
  display: flex;
  justify-content: space-between;
`

interface DefinitionProps {
  project: Project
}

const Definition: FC<DefinitionProps> = ({ project }) => (
  <Card key={project.id} className={definition}>
    <div>
      <b>{project.name}</b>
      <br />
      {project.description}
    </div>
    <BranchSelectorDialog project={project} />
  </Card>
)

export default memo(Definition)
