import Checklist from '@/editor/Checklist'
import useEditorStorage from '@/editor/useEditorStorage'
import { memo, useEffect, useState } from 'react'
import { CONCLUSION_CONDITIONS } from '../assets/pageContent/conclusion'

const ConclusionForm = () => {
  const [config, setConfig] = useEditorStorage()
  const [conditionChecked, setConditionChecked] = useState(
    config?.conclusionChecked || CONCLUSION_CONDITIONS.map(() => false)
  )

  useEffect(() => {
    setConfig(prev => ({
      ...prev,
      conclusionChecked: conditionChecked,
    }))
  }, [conditionChecked])

  return (
    <Checklist
      conditions={CONCLUSION_CONDITIONS}
      initChecked={conditionChecked}
      onInputChange={(conditionChecked: boolean[]) =>
        setConditionChecked(conditionChecked)
      }
    />
  )
}

export default memo(ConclusionForm)
