import { DialogBody, InputGroup, TextArea } from '@blueprintjs/core'
import { css } from '@emotion/css'
import type { FC } from 'react'
import { memo } from 'react'
import TooltipCheckbox from '../Tooltips/TooltipCheckbox'
import TooltipLabel from '../Tooltips/TooltipLabel'
import {
  COMMIT_PROJECT_PANEL_CONTENT_1,
  COMMIT_PROJECT_PANEL_CONTENT_2,
} from '../assets/dialogContent'
import { COMMIT_FORM } from '../assets/pageContent/gitlab'
import useGitlabStorage from '../useGitlabStorage'

const descriptionInput = css`
  width: 100%;
  height: 7rem !important;
  resize: none;
  overflow-y: auto;
`

interface ProjectPanelProps {
  newProject: boolean
  projectName: string
  projectDescription: string
  onNewProjectChange: (value: boolean) => void
  onProjectNameChange: (value: string) => void
  onProjectDescriptionChange: (value: string) => void
}

const ProjectPanel: FC<ProjectPanelProps> = ({
  newProject,
  projectName,
  projectDescription,
  onNewProjectChange,
  onProjectNameChange,
  onProjectDescriptionChange,
}) => {
  const [gitlabConfig] = useGitlabStorage()

  return (
    <DialogBody>
      {gitlabConfig?.project && (
        <div>
          <TooltipCheckbox
            label={COMMIT_FORM.newProject}
            checkboxProps={{
              checked: newProject,
              onChange: () => onNewProjectChange(!newProject),
            }}
          />
        </div>
      )}
      {!newProject && (
        <p>
          {COMMIT_PROJECT_PANEL_CONTENT_1} <b>{gitlabConfig?.project?.name}</b>{' '}
          {COMMIT_PROJECT_PANEL_CONTENT_2}
        </p>
      )}
      {(!gitlabConfig?.project || newProject) && (
        <>
          <TooltipLabel label={COMMIT_FORM.projectName}>
            <InputGroup
              placeholder='Input text'
              value={projectName}
              onChange={e => onProjectNameChange(e.target.value)}
            />
          </TooltipLabel>
          <TooltipLabel label={COMMIT_FORM.projectDescription}>
            <TextArea
              placeholder='Input text'
              value={projectDescription}
              onChange={e => onProjectDescriptionChange(e.target.value)}
              className={descriptionInput}
            />
          </TooltipLabel>
        </>
      )}
    </DialogBody>
  )
}

export default memo(ProjectPanel)
