import { DialogBody, InputGroup } from '@blueprintjs/core'
import type { FC } from 'react'
import { memo } from 'react'
import TooltipLabel from '../Tooltips/TooltipLabel'
import { COMMIT_FORM } from '../assets/pageContent/gitlab'

interface CommitPanelProps {
  commitMessage: string
  onCommitMessageChange: (value: string) => void
}

const CommitPanel: FC<CommitPanelProps> = ({
  commitMessage,
  onCommitMessageChange,
}) => (
  <DialogBody>
    <TooltipLabel label={COMMIT_FORM.commitMessage}>
      <InputGroup
        placeholder='Input text'
        value={commitMessage}
        onChange={e => onCommitMessageChange(e.target.value)}
      />
    </TooltipLabel>
  </DialogBody>
)

export default memo(CommitPanel)
