import { DialogBody, InputGroup } from '@blueprintjs/core'
import type { FC } from 'react'
import { memo } from 'react'
import BranchSelector from '../BranchSelector'
import TooltipLabel from '../Tooltips/TooltipLabel'
import TooltipSwitch from '../Tooltips/TooltipSwitch'
import { COMMIT_FORM } from '../assets/pageContent/gitlab'

interface BranchPanelProps {
  branches: string[]
  newBranch: boolean
  branchName: string
  selectedBranch?: string
  onNewBranchChange: (value: boolean) => void
  onBranchNameChange: (value: string) => void
  onSelectedBranchChange: (value: string) => void
}

const BranchPanel: FC<BranchPanelProps> = ({
  branches,
  newBranch,
  branchName,
  selectedBranch,
  onNewBranchChange,
  onBranchNameChange,
  onSelectedBranchChange,
}) => (
  <DialogBody>
    <TooltipSwitch
      label={COMMIT_FORM.newBranch}
      switchProps={{
        checked: newBranch,
        onChange: () => onNewBranchChange(!newBranch),
      }}
    />
    <TooltipLabel label={COMMIT_FORM.branch}>
      {newBranch ? (
        <InputGroup
          placeholder='Input text'
          value={branchName}
          onChange={e => onBranchNameChange(e.target.value)}
        />
      ) : (
        <BranchSelector
          branches={branches}
          selectedBranch={selectedBranch}
          onSelectedBranchChange={value => onSelectedBranchChange(value)}
        />
      )}
    </TooltipLabel>
  </DialogBody>
)

export default memo(BranchPanel)
