import { cx } from '@emotion/css'
import { ellipsized } from '@inject/shared/css/textOverflow'
import { sticky, tableCell } from './classes'
import type { Column } from './typing'

type HeadProps<T> = {
  columns: Column<T>[]
}

const Head = <T,>({ columns }: HeadProps<T>) => (
  <thead>
    <tr>
      {columns.map(column => (
        <th
          key={column.id}
          className={cx(sticky, tableCell, ellipsized, column.className)}
          style={column.style}
          title={column.name}
        >
          {column.name}
        </th>
      ))}
    </tr>
  </thead>
)
export default Head
