import {
  hidesidebar,
  useHideSidebarValue,
} from '@/clientsettings/vars/hidesidebar'
import { Button } from '@blueprintjs/core'

const HideButton = () => {
  const hide = useHideSidebarValue()
  return (
    <Button
      icon={hide ? 'menu-open' : 'menu-closed'}
      alignText='left'
      fill
      minimal
      text={!hide && 'Hide sidebar'}
      onClick={() => hidesidebar(!hidesidebar())}
      style={{ whiteSpace: 'nowrap' }}
      title={`${hide ? 'Show' : 'Hide'} sidebar`}
    />
  )
}

export default HideButton
