import type { Question } from '@inject/graphql/fragment-types'

export type QuestionProps = {
  question: Question
  answer: string
  teamId: string
  inInstructor: boolean
} & (
  | {
      type: 'answering'
      disabled: boolean | undefined
      onChange: (value: string) => void
    }
  | {
      type: 'reviewing'
      // in this type, disabled should always be true
      disabled?: never
      onChange?: never
    }
)

export type QuestionAndAnswer = {
  question: Question
  answer: string
}

export type QuestionReview = {
  questionId: string
  activateMilestones: string[]
  deactivateMilestones: string[]
  done: boolean
}
