import type { FC } from 'react'
import FreeFormQuestion from './FreeFormQuestion'
import RadioButtonQuestion from './RadioButtonQuestion'
import type { QuestionProps } from './types'

const QuestionContent: FC<QuestionProps> = props => {
  const type = props.question.type

  switch (type) {
    case 'RADIO':
      return <RadioButtonQuestion {...props} />
    case 'FREE_FORM':
      return <FreeFormQuestion {...props} />
    default:
      throw new Error(`Unsupported question type: ${type}`)
  }
}

export default QuestionContent
