import { Callout, Spinner, SpinnerSize } from '@blueprintjs/core'
import { css } from '@emotion/css'
import useBackendVersion from '@inject/graphql/utils/useBackendVersion'
import { version } from '../../../package.json'

const spinner = css`
  /* causes ever-changing overflows without the padding */
  padding: 0.2rem;
  width: max-content;
  display: inline-block;
`

const callout = css`
  display: flex;
  flex-direction: column;
  gap: 0.5rem;
`

const GitVersion = () => {
  const backendVersion = useBackendVersion()

  return (
    <Callout intent='none' className={callout}>
      <span>
        Frontend version: <code>{version}</code>
      </span>
      <span>
        Backend version:{' '}
        {backendVersion ? (
          <code>{backendVersion}</code>
        ) : (
          <Spinner size={SpinnerSize.SMALL} className={spinner} />
        )}
      </span>
    </Callout>
  )
}

export default GitVersion
