import { FormGroup, Switch } from '@blueprintjs/core'
import type { FC } from 'react'
import { useState } from 'react'
import ExerciseList from '.'

interface ManagingExerciseListProps {
  className?: string
}

const ManagingExerciseList: FC<ManagingExerciseListProps> = ({ className }) => {
  const [showFinished, setShowFinished] = useState(true)

  return (
    <div>
      <FormGroup>
        <Switch
          checked={showFinished}
          label='Show finished exercises'
          onChange={() => setShowFinished(prev => !prev)}
        />
      </FormGroup>

      <ExerciseList
        className={className}
        type='managing'
        filter={exercise => showFinished || !exercise.finished}
      />
    </div>
  )
}

export default ManagingExerciseList
