import { useNavigate } from '@/router'
import { useTypedQuery } from '@inject/graphql/graphql'
import { GetFileInfo } from '@inject/graphql/queries'
import { type FC } from 'react'
import DocViewerComponent from './DocViewerComponent'

interface DocViewerProps {
  teamId: string
  fileId: string
  inInstructor: boolean
}

const DocViewer: FC<DocViewerProps> = ({ teamId, fileId, inInstructor }) => {
  const [{ data, fetching: loading, error }] = useTypedQuery({
    query: GetFileInfo,
    variables: { fileInfoId: fileId },
  })

  const nav = useNavigate()

  return (
    <DocViewerComponent
      teamId={teamId}
      fileId={fileId}
      fileName={data?.fileInfo?.fileName || ''}
      inInstructor={inInstructor}
      loading={loading}
      error={error}
      onBack={() => nav(-1)}
    />
  )
}

export default DocViewer
