import Description from '@/components/Description'
import Tags from '@/components/Tags'
import type { Milestone } from '@inject/graphql/fragment-types'
import type { FC, ReactNode } from 'react'

interface MilestoneDescriptionProps {
  fill?: boolean
  milestone: Milestone
  getChildren: (displayName: string) => ReactNode
}

const MilestoneDescription: FC<MilestoneDescriptionProps> = ({
  milestone,
  getChildren,
}) => (
  <Description
    hideDescription={!milestone.description && milestone.tags.length === 0}
    description={
      <>
        {milestone.description && <div>{milestone.description}</div>}
        {milestone.tags.length > 0 && <Tags tagsArray={milestone.tags} />}
      </>
    }
    center
  >
    {getChildren(milestone.displayName)}
  </Description>
)

export default MilestoneDescription
