import { Button, Section } from '@blueprintjs/core'
import { useAuthIdentity } from '@inject/graphql/auth'
import { useNavigate } from 'react-router-dom'

const Voyager = () => {
  const nav = useNavigate()
  const { isSuperuser } = useAuthIdentity()

  return isSuperuser ? (
    <Section
      title='Voyager'
      subtitle='Inspect the GraphQL API visually (note: the view does not include client-side fields/schemas'
      rightElement={
        <Button icon='open-application' onClick={() => nav('/voyager')}>
          Open
        </Button>
      }
    />
  ) : (
    <></>
  )
}

export default Voyager
