import { NumericInput } from '@blueprintjs/core'
import {
  limitReactiveVar,
  useNotificationLimit,
} from '@inject/shared/notification/var/limit'
import SettingsSection from '../SettingsSection'

const NotificationLimit = () => {
  const limitValue = useNotificationLimit()

  return (
    <SettingsSection
      title='Notifications'
      subtitle='Change the number of notifications to store'
    >
      <NumericInput
        fill
        min={10}
        value={limitValue}
        onValueChange={value => limitReactiveVar(value)}
      />
    </SettingsSection>
  )
}

export default NotificationLimit
