import { Button, Section } from '@blueprintjs/core'
import useAuthIdentity from '@inject/graphql/auth'
import {
  systemNotifications,
  useSystemNotifications,
} from '@inject/shared/notification/var/systemnotifications'

const NotificationSystem = () => {
  const { isStaff } = useAuthIdentity()
  const enabled = useSystemNotifications()
  if (!('Notification' in window) || !isStaff) {
    return
  }

  return (
    <Section
      title='System Notifications'
      subtitle='Enable/disable system notifications for select notifications'
      rightElement={
        <Button
          icon='generate'
          onClick={() => {
            if (!enabled) {
              Notification.requestPermission().then(permission => {
                switch (permission) {
                  case 'granted':
                    systemNotifications(true)
                    break
                  case 'denied':
                  case 'default':
                    systemNotifications(false)
                    break
                }
              })
            } else {
              systemNotifications(false)
            }
          }}
        >
          {enabled ? 'Disable' : 'Enable'}
        </Button>
      }
    />
  )
}

export default NotificationSystem
