import { Section } from '@blueprintjs/core'
import type { FC, PropsWithChildren } from 'react'

interface SettingsSectionProps extends PropsWithChildren {
  title: string
  subtitle?: string
}

const SettingsSection: FC<SettingsSectionProps> = ({
  title,
  subtitle,
  children,
}) => (
  <Section
    title={title}
    subtitle={subtitle}
    rightElement={
      <div style={{ display: 'flex', gap: '0.25rem', alignItems: 'center' }}>
        {children}
      </div>
    }
  />
)

export default SettingsSection
