import { routes } from '@generouted/react-router'
import Connection from '@inject/graphql/connection'
import UrqlClient from '@inject/graphql/urql/client'
import PopupEngine from '@inject/shared/popup/PopupEngine'
import { RouterProvider, createBrowserRouter } from 'react-router-dom'
import DocViewerElement from './classes/DocViewerElement'

customElements.define('doc-viewer', DocViewerElement)

const Application = () => {
  const router = createBrowserRouter(routes)

  return (
    <Connection>
      <UrqlClient>
        <PopupEngine>
          <RouterProvider router={router} />
        </PopupEngine>
      </UrqlClient>
    </Connection>
  )
}

export default Application
