import { useRelativeTime } from '@/clientsettings/vars/relativeTime'
import { useContext } from 'react'
import ExerciseContext from './ExerciseContext'
import { formatTimestamp, formatTimestampRelative } from './utilities'

const useFormatTimestamp = () => {
  const { exercise } = useContext(ExerciseContext)
  const timeRelative = useRelativeTime()

  return timeRelative || !exercise.exerciseStart
    ? (timestamp: string | null) =>
        formatTimestampRelative(timestamp, exercise.exerciseStart)
    : formatTimestamp
}

export default useFormatTimestamp
