import ExerciseContext from '@/analyst/ExerciseContext'
import { injectEmailTool } from '@/analyst/utilities'
import useChannelTypeEnabled from '@inject/graphql/utils/useChannelTypeEnabled'
import { useContext } from 'react'
import useTools from './useTools'

const useToolsWithEmailsSent = () => {
  const { exercise } = useContext(ExerciseContext)
  const tools = useTools()
  const emailsEnabled = useChannelTypeEnabled('EMAIL', {
    variables: { exerciseId: exercise.id },
  })

  return emailsEnabled ? [...tools, injectEmailTool] : tools
}

export default useToolsWithEmailsSent
