import ExerciseContext from '@/analyst/ExerciseContext'
import { useTypedQuery } from '@inject/graphql/graphql'
import { GetTools } from '@inject/graphql/queries'
import notEmpty from '@inject/shared/utils/notEmpty'
import { useContext, useMemo } from 'react'

const useTools = () => {
  const { exercise } = useContext(ExerciseContext)

  const [{ data: toolsData }] = useTypedQuery({
    query: GetTools,
    variables: {
      exerciseId: exercise.id,
    },
    context: useMemo(
      () => ({
        suspense: true,
      }),
      []
    ),
  })

  return (
    toolsData && toolsData.exerciseTools
      ? toolsData.exerciseTools.filter(notEmpty)
      : []
  ).sort((a, b) => a.name.localeCompare(b.name))
}

export default useTools
