import ExerciseContext from '@/analyst/ExerciseContext'
import { useTypedQuery } from '@inject/graphql/graphql'
import { GetAnalyticsMilestones } from '@inject/graphql/queries'
import notEmpty from '@inject/shared/utils/notEmpty'
import { useContext, useMemo } from 'react'

const useMilestoneStates = () => {
  const { exercise } = useContext(ExerciseContext)

  const [{ data: milestoneStatesData }] = useTypedQuery({
    query: GetAnalyticsMilestones,
    variables: {
      exerciseId: exercise.id,
    },
    context: useMemo(
      () => ({
        suspense: true,
      }),
      []
    ),
  })

  return milestoneStatesData && milestoneStatesData.analyticsMilestones
    ? milestoneStatesData.analyticsMilestones.filter(notEmpty)
    : []
}

export default useMilestoneStates
