import ExerciseContext from '@/analyst/ExerciseContext'
import { useTypedQuery } from '@inject/graphql/graphql'
import { GetAutoInjects } from '@inject/graphql/queries'
import notEmpty from '@inject/shared/utils/notEmpty'
import { useContext, useMemo } from 'react'

const useCategories = () => {
  const { exercise } = useContext(ExerciseContext)

  const [{ data: categoriesData }] = useTypedQuery({
    query: GetAutoInjects,
    variables: {
      exerciseId: exercise.id,
    },
    context: useMemo(
      () => ({
        suspense: true,
      }),
      []
    ),
  })

  return categoriesData?.injects?.filter(notEmpty) || []
}

export default useCategories
