import ExerciseContext from '@/analyst/ExerciseContext'
import { useTypedQuery } from '@inject/graphql/graphql'
import { GetAnalyticsActionLogs } from '@inject/graphql/queries'
import notEmpty from '@inject/shared/utils/notEmpty'
import { useContext, useMemo } from 'react'

const useActionLogs = () => {
  const { exercise } = useContext(ExerciseContext)

  const [{ data: actionLogsData }] = useTypedQuery({
    query: GetAnalyticsActionLogs,
    variables: {
      exerciseId: exercise.id,
    },
    context: useMemo(
      () => ({
        suspense: true,
      }),
      []
    ),
  })

  return actionLogsData && actionLogsData.analyticsActionLogs
    ? actionLogsData.analyticsActionLogs.filter(notEmpty)
    : []
}

export default useActionLogs
