import useFormatTimestamp from '@/analyst/useFormatTimestamp'
import type { FC } from 'react'

interface CommandActionLogTooltipProps {
  teamName: string | undefined
  timestamp: string | null
  toolName: string
  argument: string
  response: string
}

const CommandActionLogTooltip: FC<CommandActionLogTooltipProps> = ({
  teamName,
  timestamp,
  toolName,
  argument,
  response,
}) => {
  const formatTimestamp = useFormatTimestamp()

  return (
    <>
      {teamName && (
        <>
          <strong>Team: </strong>
          <span>{teamName}</span>
          <br />
        </>
      )}
      <strong>Tool: </strong>
      <span>{toolName}</span>
      <br />
      <strong>Argument: </strong>
      <span>{argument}</span>
      <br />
      <strong>Response: </strong>
      <span>{response}</span>
      <br />
      <strong>Timestamp: </strong>
      <span>{formatTimestamp(timestamp)}</span>
    </>
  )
}

export default CommandActionLogTooltip
