import type { MilestoneState } from '@inject/graphql/fragment-types'
import type { FC } from 'react'
import useFormatTimestamp from '../useFormatTimestamp'

interface MilestoneTooltipProps {
  milestone: MilestoneState
}

const MilestoneTooltip: FC<MilestoneTooltipProps> = ({ milestone }) => {
  const formatTimestamp = useFormatTimestamp()

  return (
    <>
      <strong>Type: </strong>
      <span>MILESTONE</span>
      <br />
      <strong>Name: </strong>
      <span>{milestone.milestone.displayName}</span>
      <br />
      <strong>Timestamp: </strong>
      <span>{formatTimestamp(milestone.timestampReached)}</span>
    </>
  )
}

export default MilestoneTooltip
