import Tags from '@/components/Tags'
import type { MilestoneState } from '@inject/graphql/fragment-types'
import type { FC } from 'react'
import useFormatTimestamp from '../useFormatTimestamp'
import { td, th } from './detailStyles'

interface MilestoneDetailProps {
  milestone: MilestoneState
}

const MilestoneDetail: FC<MilestoneDetailProps> = ({ milestone }) => {
  const formatTimestamp = useFormatTimestamp()

  return (
    <div>
      <table>
        <tbody>
          <tr>
            <th className={th}>Name</th>
            <td className={td}>{milestone.milestone.displayName}</td>
          </tr>
          {milestone.milestone.description && (
            <tr>
              <th className={th}>Description</th>
              <td className={td}>{milestone.milestone.description}</td>
            </tr>
          )}
          {milestone.milestone.tags.length > 0 && (
            <tr>
              <th className={th}>Tags</th>
              <td className={td}>
                <Tags tagsArray={milestone.milestone.tags} />
              </td>
            </tr>
          )}
          {milestone.reached && (
            <tr>
              <th className={th}>Timestamp</th>
              <td className={td}>
                {formatTimestamp(milestone.timestampReached)}
              </td>
            </tr>
          )}
          <tr>
            <th className={th}>Teams</th>
            <td className={td}>{milestone.teamIds?.join(', ')}</td>
          </tr>
        </tbody>
      </table>
    </div>
  )
}

export default MilestoneDetail
