import { textFromRenderedContent } from '@/utils'
import type { EmailDetails } from '@inject/graphql/fragment-types'
import type { FC } from 'react'
import useFormatTimestamp from '../useFormatTimestamp'

interface EmailTooltipProps {
  emailDetails: EmailDetails
}

const EmailTooltip: FC<EmailTooltipProps> = ({ emailDetails }) => {
  const formatTimestamp = useFormatTimestamp()

  return (
    <>
      <strong>Type: </strong>
      <span>EMAIL</span>
      <br />
      <strong>Subject: </strong>
      <span>{emailDetails.thread.subject}</span>
      <br />
      <strong>Content: </strong>
      <span>{textFromRenderedContent(emailDetails.content.rendered)}</span>
      <br />
      <strong>Timestamp: </strong>
      <span>{formatTimestamp(emailDetails.timestamp)}</span>
    </>
  )
}

export default EmailTooltip
