import useTools from '@/analyst/dataHooks/useTools'
import { Tooltip } from '@blueprintjs/core'
import type { ActionLog, ToolDetails } from '@inject/graphql/fragment-types'
import type { FC } from 'react'
import { useContext, useRef } from 'react'
import type { XScale, YScale } from '../Plots/ScatterPlot/types'
import { ACTION_TYPES, actionTypeColor, plotDataElement } from '../utilities'
import ActionTooltip from './ActionTooltip'
import FilterContext from './FilterContext'

interface ActionIconProps {
  actionLog: ActionLog
  opacity: number
  onClick: () => void
  xScale: XScale
  yScale: YScale
  dotSize: number
}

const ActionIcon: FC<ActionIconProps> = ({
  actionLog,
  opacity,
  onClick,
  xScale,
  yScale,
  dotSize,
}) => {
  const ref = useRef<SVGCircleElement>(null)

  const { displayActionLogs, displayActionType, displayTool } =
    useContext(FilterContext)
  const tools = useTools()

  return (
    <Tooltip
      targetTagName='g'
      content={<ActionTooltip actionLog={actionLog} />}
      position='right'
    >
      <circle
        ref={ref}
        className={plotDataElement}
        cx={xScale(new Date(actionLog.timestamp || 0))}
        cy={Number(yScale(actionLog.team.name))}
        r={dotSize / 2}
        fill={actionTypeColor(actionLog.type.toString())}
        opacity={opacity}
        onClick={onClick}
        style={{
          display:
            displayActionLogs &&
            displayActionType[ACTION_TYPES.indexOf(actionLog.type)] &&
            (actionLog.type !== 'TOOL' ||
              displayTool[
                tools.findIndex(
                  tool => tool.id === (actionLog.details as ToolDetails).tool.id
                )
              ])
              ? 'initial'
              : 'none',
        }}
      />
    </Tooltip>
  )
}

export default ActionIcon
