import { Button } from '@blueprintjs/core'
import type { BlueprintIcons_16Id } from '@blueprintjs/icons/lib/esm/generated/16px/blueprint-icons-16'
import type { FC, PropsWithChildren } from 'react'

interface TabButtonProps extends PropsWithChildren {
  onClick?: () => void
  active?: boolean
  icon?: BlueprintIcons_16Id
}

const TabButton: FC<TabButtonProps> = ({ children, onClick, icon, active }) => (
  <Button
    minimal
    style={{
      minWidth: 'fit-content',
    }}
    active={active}
    onClick={onClick}
    icon={icon}
  >
    {children}
  </Button>
)

export default TabButton
