import { Button, Collapse } from '@blueprintjs/core'
import type { Tool } from '@inject/graphql/fragment-types'
import type { FC } from 'react'
import { useState } from 'react'
import GrapheneForm from './components/GrapheneForm'

interface ToolActionProps {
  grapheneTool: Tool
  teamId: string
  disabled?: boolean
  disabledTitle?: string
}

const ToolAction: FC<ToolActionProps> = ({
  grapheneTool,
  teamId,
  disabled,
  disabledTitle,
}) => {
  const [open, setOpen] = useState<boolean>(false)
  const newName = grapheneTool.name.split('_')[1] ?? grapheneTool.name

  return (
    <>
      <Button
        ellipsizeText
        fill
        minimal
        alignText='left'
        icon='sensor'
        text={newName}
        title={newName}
        onClick={() => setOpen(prev => !prev)}
      />
      <Collapse isOpen={open}>
        <GrapheneForm
          grapheneTool={grapheneTool}
          teamId={teamId}
          setOpen={setOpen}
          disabled={disabled}
          disabledTitle={disabledTitle}
        />
      </Collapse>
    </>
  )
}

export default ToolAction
