import type { IconName } from '@blueprintjs/icons'
import type { SimplifiedActionLog } from '@inject/graphql/fragment-types'

/*
 * TODO: improve TS linting performance, likely culprit is tada
 * TODO: enforce typing of client., we may use type masking here
 * TODO: devise a way to infer types, prolly codegen toolchain
 */
export const getIcon = (injectType: SimplifiedActionLog['type']): IconName => {
  switch (injectType) {
    case 'INJECT':
      return 'info-sign'
    case 'CUSTOM_INJECT':
      return 'info-sign'
    case 'EMAIL':
      return 'envelope'
    case 'TOOL':
      return 'console'
    case 'FORM':
      return 'form'
    default:
      throw new Error(`unknown channel type: ${injectType}`)
  }
}

export const getTitle = (actionLog: SimplifiedActionLog): string => {
  switch (actionLog.details.__typename) {
    case 'InjectDetailsType':
      return actionLog.details.inject.organization
    case 'CustomInjectDetailsType':
      return ''
    case 'EmailType':
      return actionLog.details.sender.address
    case 'ToolDetailsType':
      return actionLog.details.tool.name
    case 'QuestionnaireType':
      return actionLog.details.title
    default:
      throw new Error(`unknown channel type: ${actionLog.type}`)
  }
}
