FROM python:3.8-alpine

ENV POETRY_NO_INTERACTION=1 \
    POETRY_VIRTUALENVS_IN_PROJECT=1 \
    POETRY_VIRTUALENVS_CREATE=1 \
    POETRY_CACHE_DIR=/tmp/poetry_cache

WORKDIR /backend

# Install poetry
RUN apk add gcc musl-dev libffi-dev && \
    rm -rf /var/cache/apk/
RUN pip install poetry==1.8.2 --no-cache

ENTRYPOINT [ "/bin/sh", "be-dev.sh" ]
EXPOSE 8000