# INJECT Frontend

A monorepo of the INJECT Exercise Platform.

## Sub-repositories

- [frontend](./frontend/) - The main repository with components specific to INJECT Frontend
- [graphql](./graphql/) - A library for the communication with the GraphQL-based backend
- [shared](./shared/) - A library for components and config shared between other repositories
- backend - A Git submodule with the currently supported backend
  - This folder is unused in releases
  - Prefer using tagged commits
  - The submodule points to [this GitLab repository](https://gitlab.fi.muni.cz/inject/backend). Locally, it will be present in [this folder](./backend/)

## How to run

To ensure the frontend application functions properly, it's necessary to have a backend instance up and running. Refer to the [INJECT Backend repository](https://gitlab.fi.muni.cz/inject/backend) for instructions.

To run the frontend application, you have two options:

1. Running with [yarn](#running-with-yarn) (used for development)
2. Running with [Docker](INSTALLATION.md) (used for production)

## Development in VSCode

It is recommended to develop the INJECT Frontend application in [Visual Studio Code](https://code.visualstudio.com/) on Linux or in a [WSL](https://learn.microsoft.com/en-us/windows/wsl/install).

We recommend to use the following workspace settings (copy them into `./vscode/settings.json`):

```
{
  "typescript.tsdk": ".yarn/sdks/typescript/lib",
  "javascript.updateImportsOnFileMove.enabled": "never",
  "typescript.updateImportsOnFileMove.enabled": "never",
  "search.exclude": {
    "**/.yarn": true,
    "**/.pnp.*": true
  },
  "prettier.prettierPath": ".yarn/sdks/prettier/index.cjs",
  "typescript.enablePromptUseWorkspaceTsdk": true,
  "eslint.nodePath": ".yarn/sdks",
  "eslint.useFlatConfig": true,
  "editor.codeActionsOnSave": {
    "source.fixAll": "always"
  }
}
```

Recommendations on VSCode extensions are listed in [the extensions file](./.vscode/extensions.json).

## Running with yarn

To run the frontend application using yarn, ensure you have the following prerequisites:

- [Node 20 LTS](https://nodejs.org/en)
- [Yarn](https://yarnpkg.com/)

Once you have the backend application running and the prerequisites installed, follow these steps:

First run the following command to install project dependencies:

```
yarn
```

Then run the frontend development server:

```
yarn dev
```

If you're on Windows, ensure that Git is installed and run the command in GitBash:

```
GIT_ENABLED=1 yarn dev
```

If you want to build the app for deployment, then follow these steps:

Compile the TypeScript code:

```
yarn prebuild
```

Then build the `dist/` folder:

```
yarn build
```

## How to update GraphQL calls using Codegen

To aid in development and work with GraphQL, the project uses a tool called [Codegen](https://the-guild.dev/graphql/codegen), which generates TypeScript code for working with the GraphQL API defined by the backend application.

The fragments, queries, mutations, and subscriptions to implement are specified in [codegen/gql](./codegen/gql/).

To update the generated files after implementing changes in the GraphQL API (either on the backend or in the [related frontend folder](./codegen/gql/)), simply run the [prepared script](./docker/schema-gen/update.sh) while the backend application is running:

Change the working directory:

```
cd docker/schema-gen/
```

Run the script:

```
sh update.sh
```

## How to update the backend version

1. Update the [backend Git submodule](#sub-repositories) to the desired commit
2. Update the version fields in package.json files to match the backend version

   - either manually or through the create-tag [CI/CD pipeline](./.gitlab-ci.yml)

3. [Update GraphQL calls using Codegen](#how-to-update-graphql-calls-using-codegen)
4. Make sure to address all changes and new features

## Quality Control

The code uses a set of ESLint and Prettier rules to improve legibility and enforce React conventions.

To check formatting and lint the code, run:

```
yarn lint
```

## Most important dependencies

- [Ahooks](https://ahooks.js.org/hooks/use-request/index) (for common React Hooks)
- [BlueprintJS](https://blueprintjs.com/docs/) (for UI)
- [Emotion](https://emotion.sh/docs/introduction) (for CSS-in-JS)
- [Generouted](https://github.com/oedotme/generouted) (for routing)
- [GraphQL-Codegen](https://the-guild.dev/graphql/codegen) (for generating TypeScript code for working with a GraphQL API)

## Usage of the repository in documentation

Parts of this repository are used automatically via a pipeline in the INJECT documentation. For more details, see the script that downloads and handles these files: [utilities.sh](https://gitlab.fi.muni.cz/inject/inject-docs/-/blob/main/utilities.sh?ref_type=heads). Some `.md` files may also include an attribute in the frontmatter `tags: used_in_docs` to indicate that they are used in the docs.
