package cz.fidentis.analyst.scene;

import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.mesh.core.MeshModel;
import cz.fidentis.analyst.symmetry.Plane;
import javax.vecmath.Point3d;

/**
 * A plane to be shown as a rectangular mesh facet.
 * 
 * @author Radek Oslejsek
 * @author Dominik Racek
 */
public class DrawablePlane extends DrawableMesh {
    
    private final Plane plane;
    
    /**
     * Copy constructor.
     * @param drPlane Original plane
     * @throws NullPointException if the input argument is {@code null}
     */
    public DrawablePlane(DrawablePlane drPlane) {
        super(drPlane);
        this.plane = new Plane(drPlane.getPlane());
    }
    
    /**
     * Constructor.
     * @param model Mesh model of the plane
     * @param plane The plane
     */
    public DrawablePlane(MeshModel model, Plane plane) {
        super(model);
        if (plane == null) {
            throw new IllegalArgumentException("plane");
        }
        this.plane = plane;
    }
    
    /**
     * Constructor.
     * @param facet Mesh facet of the plane
     * @param plane The plane
     */
    public DrawablePlane(MeshFacet facet, Plane plane) {
        super(facet);
        if (plane == null) {
            throw new IllegalArgumentException("plane");
        }
        this.plane = new Plane(plane);
    }
    
    /**
     * Constructor.
     * 
     * @param plane The plane
     * @param midPoint A 3D point, which is projected to the plane and used as a center of the rectangular facet
     * @param width Width
     * @param height Height
     * @throws NullPointerException if the {@code plane} or {@code midPoint} are {@code null}
     * @throws IllegalArgumentException if {@code width} or {@code height} are &lt;= 0
     */
    public DrawablePlane(Plane plane, Point3d midPoint, double width, double height) {
        super(plane.getMesh(midPoint, width, height));
        this.plane = new Plane(plane);
    }

    public Plane getPlane() {
        return plane;
    }

}
